/*
 * Decompiled with CFR 0.152.
 */
package com.ncpbails.culturaldelights.block.custom;

import com.ncpbails.culturaldelights.block.ModBlocks;
import com.ncpbails.culturaldelights.block.custom.CornUpperBlock;
import com.ncpbails.culturaldelights.item.ModItems;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class CornBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public static final BooleanProperty SUPPORTING = BooleanProperty.m_61465_((String)"supporting");
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};

    public CornBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)SUPPORTING, (Comparable)Boolean.valueOf(false)));
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        float chance;
        int age;
        super.m_7458_(state, worldIn, pos, rand);
        if (worldIn.isAreaLoaded(pos, 1) && worldIn.m_45524_(pos.m_7494_(), 0) >= 6 && (age = this.getAge(state)) <= this.getMaxAge() && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt((int)(25.0f / (chance = 10.0f)) + 1) == 0 ? 1 : 0) != 0)) {
            if (age == this.getMaxAge()) {
                CornUpperBlock cornUpper = (CornUpperBlock)((Object)ModBlocks.CORN_UPPER.get());
                if (cornUpper.m_49966_().m_60710_((LevelReader)worldIn, pos.m_7494_()) && worldIn.m_46859_(pos.m_7494_())) {
                    worldIn.m_46597_(pos.m_7494_(), cornUpper.m_49966_());
                    ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
                }
            } else {
                worldIn.m_7731_(pos, this.withAge(age + 1), 2);
                ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)this.getAgeProperty())];
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty());
    }

    public int getMaxAge() {
        return 3;
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ModItems.CORN_KERNELS.get());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, SUPPORTING});
    }

    public boolean isSupportingCornUpper(BlockState topState) {
        return topState.m_60734_() == ModBlocks.CORN_UPPER.get();
    }

    public boolean canGrow(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        BlockState upperState = worldIn.m_8055_(pos.m_7494_());
        if (upperState.m_60734_() instanceof CornUpperBlock) {
            return !((CornUpperBlock)upperState.m_60734_()).m_52307_(upperState);
        }
        return true;
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        BlockState upperState = worldIn.m_8055_(pos.m_7494_());
        if (upperState.m_60734_() instanceof CornUpperBlock) {
            return !((CornUpperBlock)upperState.m_60734_()).m_52307_(upperState);
        }
        return true;
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    protected int getBonemealAgeIncrease(Level worldIn) {
        return Mth.m_14072_((Random)worldIn.f_46441_, (int)1, (int)4);
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        int ageGrowth = Math.min(this.getAge(state) + this.getBonemealAgeIncrease((Level)worldIn), 7);
        if (ageGrowth <= this.getMaxAge()) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(ageGrowth)));
        } else {
            BlockState top = worldIn.m_8055_(pos.m_7494_());
            if (top.m_60734_() == ModBlocks.CORN_UPPER.get()) {
                BonemealableBlock growable = (BonemealableBlock)worldIn.m_8055_(pos.m_7494_()).m_60734_();
                if (growable.m_7370_((BlockGetter)worldIn, pos.m_7494_(), top, false)) {
                    growable.m_7719_(worldIn, worldIn.f_46441_, pos.m_7494_(), top);
                }
            } else {
                CornUpperBlock cornUpper = (CornUpperBlock)((Object)ModBlocks.CORN_UPPER.get());
                int remainingGrowth = ageGrowth - this.getMaxAge() - 1;
                if (cornUpper.m_49966_().m_60710_((LevelReader)worldIn, pos.m_7494_()) && worldIn.m_46859_(pos.m_7494_())) {
                    worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(this.getMaxAge())));
                    worldIn.m_7731_(pos.m_7494_(), (BlockState)cornUpper.m_49966_().m_61124_((Property)CornUpperBlock.CORN_AGE, (Comparable)Integer.valueOf(remainingGrowth)), 2);
                }
            }
        }
    }
}

